### Disclaimer

The content of the Postman-Collection is constantly updated and might be outdated quickly.

If you encounter any problems, please open a ticket via the [bLink Support Portal](https://web.banking-services.six-group.com/service-management/servicedesk/customer/portal/41)

### Prerequisites

To use the collection provided here on the SIX test environment, the following is required:

* Postman v8.5.x or later
* Certificate which has been whitelisted by SIX for mTLS

### Getting Started

1. `Settings` &rarr; `Automatically follow redirects` &rarr; `Off`
1. Tab `Certificates` &rarr; "Add Certificate"
    * Host = `api-qa.np.six-group.com`
    * CRT file &rarr; `Select File` &rarr; (your public certificate)
    * KEY file &rarr; `Select File` &rarr; (your private key)
    * Passphrase &rarr; (your passphrase)
1. `File` &rarr; `Import`
1. `Upload Files` &rarr; choose both json files &rarr; `Import`
1. `Environments` &rarr; "(bLink) xe for customers (...) tpps" 
    * replace `ask bLink.support@six-group.com` with
      the correct values
    * replace `set your scopes` with the scopes you are registered for (space delimited). Possible values are `urn:blink:xs2a:ais urn:blink:xs2a:pss:write urn:blink:ow:cstdy urn:blink:ow:custmgmt:write urn:blink:ow:ordrplc:write`

### How to use the Consent-Flows (Consent-as-a-Service 'CaaS' and Consent-Flow 2.0 without CaaS)

The Postman Collection is structured with a separate folder for the `consent-flow`. All requests have a number or
letter corresponding to the documentation provided separately.

Specialities of the Collection:

* all access tokens and cookies are handled automatically between the calls (see `Tests` and `Test Results` Tabs)
* `[9.1] & [9.2] E-Banking Login Submit`: The "E-Banking Login" is simulated by the Service-Provider Simulator and the
IDP component. 
    * it uses OIDC for authentication.
    * `[8.1] E-Banking Login Form` redirects to the IDP Login-Form-URL with OIDC parameters set in the query path 
    * a Cookie is required which is why the `[8.2] E-Banking Login Form` has to be requested before the IDP-Login will
      work
    * login will only work if the user doesn't already have an active session (if in doubt, just
      use `E-Banking Logout 1 & 2`)
* `[7] /oauth/authorize`: Requires an active "E-Banking Session" from the Service Provider Simulator: use Calls `[8.1]`
   & `[8.2]` & `[9.1]` & `[9.2]`
* `[7] /oauth/authorize`: If the user doesn't have an active "E-Banking Session" from the Service Provider Simulator,
  the Call `[7] /oauth/authorize` will return with a `302 redirect` response containing `?login` which points to the
  login form
    * a successful response shows `303 See Other` with a `Location` header and empty body
    * the following query parameters will control token-properties if the request is sent to the blink service-provider-simulator
      * multiple_tokens_per_user: if value is set to "true" the simulator will emit a new token with every consent executed
      * token_expiration: the expiration time of the access-token in seconds that is linked to the permission of this consent (requires "multiple_tokens_per_user" set to true if a valid access-token for a consent already exists for this simulator-user)
      * refresh_token_expiration: the expiration time of the refresh-token in seconds that is linked to the permission of this consent (requires "multiple_tokens_per_user" set to true if a valid access-token for a consent already exists for this simulator-user)
* if for any of the requests, Postman shows `http 407`, try restarting Postman (it appears to be a bug in Postman)
* `/directory`: simply requires a whitelisted client certificate 
